

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCaseResponsesAndStatums]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[VX_sp_GetCaseResponsesAndStatums]
GO


CREATE PROCEDURE [dbo].[VX_sp_GetCaseResponsesAndStatums]
       @nvcCaseNumbers NVARCHAR(MAX)
AS
BEGIN
-----------------------
-- Debugging section
--
--     DECLARE @nvcCaseNumbers NVARCHAR(MAX)
--     SET @nvcCaseNumbers = '''0000000001'',''0000000002'''

       EXEC('
             SELECT [ResRespondent],[ResLanguage],[ResTimeZone],[ResCallbackDate],[ResIntervCall],[ResTimeSlot],[ResCallCount],[ResLastCallDate],[ResVersion],[ResPriority],[ResCompleted],[ResConfidPhone],[ResSeed],[Resphone],[ResCodeResult],[ResWaveNo],[ResBlocked],[ResCompPredictive],[ResCall],[ResMonitored],[ResLastCompQuest],[ResPreviousCallDate],[ResWaveImportNo],[projectId],[collectMode],[modifiedBy],[modified],[panelistId],[Location],[ResActive],[DialingMode],[RestrictionOverride],[IntLevel],[ResNextIntervCall],[CyclePhoneNumber],[ManualDialing]
             INTO #AssignedCases
             FROM Respondent 
             WHERE ResRespondent IN ('+@nvcCaseNumbers+')

             SELECT * FROM #AssignedCases
             
             SELECT RpsRespondent, RpsQuestion, RpsMatrix, RpsMention, RpsContent, RpsOpened, RpsType, projectId, collectMode, modifiedBy, modified  
             FROM Response WHERE RpsRespondent IN (SELECT ResRespondent FROM #AssignedCases)
             
             -- Stratum
             SELECT st.[StrRespondent], st.[StrStratum], st.[StrQuotaId], st.[IncrementValue] FROM #AssignedCases AS resp
             INNER JOIN [Stratum] AS st ON st.[StrRespondent] = resp.[ResRespondent]
             
             -- Historic
             SELECT [HisRespondent],[HisCallNumber],[HisInterviewer],[HisResult],[HisCallDate],[HisTimeSlot],[HisCallDuration],[HisDataType],[HisStartQuestion],[HisEndQuestion],[HisMonitoring],[HisDialerLine],[HisWait],[HisPause],[HisFileReference],[HisPreviousCallDate],[HisLifeState],his.[projectId],his.[collectMode],[HisPhone],his.[DialingMode],[LevelChanged],[Notes],[RuleId],[ExtRuleId],[NextCallBack],[IsImported],[HisCaseResult],[A4SCallNumber] FROM #AssignedCases AS resp
             INNER JOIN [Historic] AS his ON his.[HisRespondent] = resp.[ResRespondent]

             -- Note
             SELECT note.* FROM #AssignedCases AS resp
             INNER JOIN [Note] AS note ON note.[NotRespondent] = resp.[ResRespondent]
             
             DROP TABLE #AssignedCases
       ')
END
GO


